/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.richtext.v2_1;

import com.roguewave.chart.richtext.v2_1.BlockContext;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import java.awt.Graphics;
import java.util.Vector;

public class HConcatenation
implements TextBlock {
    Vector blocks_ = new Vector();

    public void addBlock(TextBlock block) {
        this.blocks_.addElement(block);
    }

    public int getWidth(BlockContext bc) {
        int width = 0;
        for (int i = 0; i < this.blocks_.size(); ++i) {
            width += ((TextBlock)this.blocks_.elementAt(i)).getWidth(bc);
        }
        return width;
    }

    public int getHeight(BlockContext bc) {
        int height = 0;
        for (int i = 0; i < this.blocks_.size(); ++i) {
            int blockHeight = ((TextBlock)this.blocks_.elementAt(i)).getHeight(bc);
            if (blockHeight <= height) continue;
            height = blockHeight;
        }
        return height;
    }

    public int getAscent(BlockContext bc) {
        int ascent = 0;
        for (int i = 0; i < this.blocks_.size(); ++i) {
            int blockAscent = ((TextBlock)this.blocks_.elementAt(i)).getAscent(bc);
            if (blockAscent <= ascent) continue;
            ascent = blockAscent;
        }
        return ascent;
    }

    public void init(BlockContext bc) {
        for (int i = 0; i < this.blocks_.size(); ++i) {
            ((TextBlock)this.blocks_.elementAt(i)).init(bc);
        }
    }

    public void render(BlockContext bc) {
        int ascent = this.getAscent(bc);
        int x = bc.getX();
        int y = bc.getY();
        Graphics g = bc.getGraphics();
        BlockContext context = new BlockContext(x, y, g);
        for (int i = 0; i < this.blocks_.size(); ++i) {
            TextBlock block = (TextBlock)this.blocks_.elementAt(i);
            int blockAscent = block.getAscent(context);
            int ly = y + (ascent - blockAscent);
            context.setY(ly);
            block.render(context);
            context.setX(x += block.getWidth(context));
        }
    }
}

